/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.world.features;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BlockPlantWall;
import org.betterx.betternether.noise.OpenSimplexNoise;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.NetherBiomeBuilder;
import org.betterx.betternether.world.features.ContextFeature;
import org.betterx.betternether.world.structures.StructureGeneratorThreadContext;
import org.betterx.betternether.world.structures.plants.LegacyStructureAnchorTree;

public class AnchorTreeFeature
extends ContextFeature<NoneFeatureConfiguration> {
    protected static final OpenSimplexNoise NOISE = new OpenSimplexNoise(2145L);
    public static final Block[] wallPlants = new Block[]{NetherBlocks.JUNGLE_MOSS, NetherBlocks.JUNGLE_MOSS, NetherBlocks.WALL_MUSHROOM_BROWN, NetherBlocks.WALL_MUSHROOM_RED};
    private final LegacyStructureAnchorTree legacyStructure = new LegacyStructureAnchorTree();

    public AnchorTreeFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    private static int toMiddle(int val) {
        return val + (7 - (val & 0xF));
    }

    @Override
    protected boolean place(ServerLevelAccessor world, BlockPos pos, RandomSource random, NoneFeatureConfiguration config, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        pos = new BlockPos(AnchorTreeFeature.toMiddle(pos.m_123341_()), pos.m_123342_(), AnchorTreeFeature.toMiddle(pos.m_123343_()));
        if (NetherBiomeBuilder.useLegacyGeneration) {
            this.legacyStructure.generate(world, pos, random, MAX_HEIGHT, context);
            return true;
        }
        BlockPos down = pos.m_6625_(BlocksHelper.downRay((LevelAccessor)world, pos, MAX_HEIGHT));
        if (this.canGenerate(pos)) {
            this.grow(world, pos, down, random, MAX_HEIGHT, context);
            return true;
        }
        return false;
    }

    private boolean canGenerate(BlockPos pos) {
        return true;
    }

    private void grow(ServerLevelAccessor level, BlockPos up, BlockPos down, RandomSource random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        int SEGMENT_LENGTH;
        int HEIGHT_90;
        int HEIGHT_45;
        int HEIGHT_64;
        float scale_factor = (float)MAX_HEIGHT / 128.0f;
        if (NetherBiomeBuilder.useLegacyGeneration) {
            HEIGHT_64 = MAX_HEIGHT / 2;
            HEIGHT_45 = (int)((double)MAX_HEIGHT * 0.36);
            HEIGHT_90 = (int)((double)MAX_HEIGHT * 0.7);
            SEGMENT_LENGTH = (int)(15.0f * scale_factor);
        } else {
            HEIGHT_64 = (int)((double)MAX_HEIGHT / 4.0 + (double)MHelper.nextFloat(random, 32.0f));
            HEIGHT_45 = (int)(20.0f + MHelper.nextFloat(random, 20.0f * scale_factor));
            HEIGHT_90 = (int)((double)MAX_HEIGHT / 2.0 + (double)MHelper.nextFloat(random, 15.0f * scale_factor));
            SEGMENT_LENGTH = (int)((15.0f + MHelper.nextFloat(random, 5.0f * scale_factor)) * scale_factor);
        }
        if (up.m_123342_() - down.m_123342_() < 30) {
            return;
        }
        int pd = BlocksHelper.downRay((LevelAccessor)level, down, MAX_HEIGHT) + 1;
        for (int i = 0; i < 5; ++i) {
            Block block = level.m_8055_(down.m_6625_(pd + i)).m_60734_();
            if (block != Blocks.f_50197_ && block != NetherBlocks.NETHER_BRICK_TILE_LARGE && block != NetherBlocks.NETHER_BRICK_TILE_SMALL) continue;
            return;
        }
        BlockPos trunkTop = this.lerp(down, up, 0.6);
        BlockPos trunkBottom = this.lerp(down, up, 0.3);
        int count = (trunkTop.m_123342_() - trunkBottom.m_123342_()) / 7;
        if (count < 2) {
            count = 2;
        }
        List<BlockPos> blocks = this.line(trunkBottom, trunkTop, count, random, 2.5);
        context.BLOCKS.clear();
        count = Math.min(7, Math.max(3, (up.m_123342_() - down.m_123342_()) / (int)(10.0f * scale_factor) - 1));
        double radius = Math.min(7.0, Math.max(3.5, (double)((up.m_123342_() - down.m_123342_()) / 15)));
        this.drawLine(level, blocks, radius + 0.5 * (double)scale_factor, MAX_HEIGHT, context);
        this.buildBigCircle(level, up, trunkTop, SEGMENT_LENGTH, count, 2, random.m_188500_() * Math.PI * 2.0, radius, random, MAX_HEIGHT, context);
        this.buildBigCircle(level, up, trunkBottom, -SEGMENT_LENGTH, count, 2, random.m_188500_() * Math.PI * 2.0, radius, random, MAX_HEIGHT, context);
        int offset = random.m_188503_(4);
        int minBuildHeight = level.m_141937_() + 1;
        BoundingBox blockBox = BlocksHelper.decorationBounds((LevelAccessor)level, up, minBuildHeight, MAX_HEIGHT - 2);
        for (BlockPos bpos : context.BLOCKS) {
            BlockState state;
            if (!blockBox.m_71051_((Vec3i)bpos) || !BlocksHelper.isNetherGround(state = level.m_8055_(bpos)) && !state.m_247087_()) continue;
            boolean blockUp = true;
            blockUp = context.BLOCKS.contains(bpos.m_7494_());
            if (blockUp && context.BLOCKS.contains(bpos.m_7495_())) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)level, bpos, NetherBlocks.MAT_ANCHOR_TREE.getLog().m_49966_());
            } else {
                BlocksHelper.setWithoutUpdate((LevelAccessor)level, bpos, NetherBlocks.MAT_ANCHOR_TREE.getBark().m_49966_());
            }
            if (bpos.m_123342_() > HEIGHT_45 && bpos.m_123342_() < HEIGHT_90 && (bpos.m_123342_() & 3) == offset && NOISE.eval((double)bpos.m_123341_() * 0.1, (double)bpos.m_123342_() * 0.1, (double)bpos.m_123343_() * 0.1) > 0.0) {
                if (random.m_188503_((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.m_122012_())) {
                    AnchorTreeFeature.makeMushroom(level, bpos.m_122012_(), random.m_188500_() * 3.0 + 1.5, blockBox);
                }
                if (random.m_188503_((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.m_122019_())) {
                    AnchorTreeFeature.makeMushroom(level, bpos.m_122019_(), random.m_188500_() * 3.0 + 1.5, blockBox);
                }
                if (random.m_188503_((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.m_122029_())) {
                    AnchorTreeFeature.makeMushroom(level, bpos.m_122029_(), random.m_188500_() * 3.0 + 1.5, blockBox);
                }
                if (random.m_188503_((int)(32.0f * scale_factor)) == 0 && !context.BLOCKS.contains(bpos.m_122024_())) {
                    AnchorTreeFeature.makeMushroom(level, bpos.m_122024_(), random.m_188500_() * 3.0 + 1.5, blockBox);
                }
            }
            if (bpos.m_123342_() <= HEIGHT_64) continue;
            if (!blockUp && level.m_8055_(bpos.m_7494_()).m_247087_()) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)level, bpos.m_7494_(), NetherBlocks.MOSS_COVER.m_49966_());
            }
            if (!(NOISE.eval((double)bpos.m_123341_() * 0.05, (double)bpos.m_123342_() * 0.05, (double)bpos.m_123343_() * 0.05) > 0.0)) continue;
            state = wallPlants[random.m_188503_(wallPlants.length)].m_49966_();
            BlockPos _pos = bpos.m_122012_();
            if (random.m_188503_(8) == 0 && !context.BLOCKS.contains(_pos) && level.m_46859_(_pos) && _pos.m_123343_() >= blockBox.m_162398_()) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)level, _pos, (BlockState)state.m_61124_((Property)BlockPlantWall.FACING, (Comparable)Direction.NORTH));
            }
            _pos = bpos.m_122019_();
            if (random.m_188503_(8) == 0 && !context.BLOCKS.contains(_pos) && level.m_46859_(_pos) && _pos.m_123343_() <= blockBox.m_162401_()) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)level, _pos, (BlockState)state.m_61124_((Property)BlockPlantWall.FACING, (Comparable)Direction.SOUTH));
            }
            _pos = bpos.m_122029_();
            if (random.m_188503_(8) == 0 && !context.BLOCKS.contains(_pos) && level.m_46859_(_pos) && _pos.m_123341_() <= blockBox.m_162399_()) {
                BlocksHelper.setWithoutUpdate((LevelAccessor)level, _pos, (BlockState)state.m_61124_((Property)BlockPlantWall.FACING, (Comparable)Direction.EAST));
            }
            _pos = bpos.m_122024_();
            if (random.m_188503_(8) != 0 || context.BLOCKS.contains(_pos) || !level.m_46859_(_pos) || _pos.m_123341_() < blockBox.m_162395_()) continue;
            BlocksHelper.setWithoutUpdate((LevelAccessor)level, _pos, (BlockState)state.m_61124_((Property)BlockPlantWall.FACING, (Comparable)Direction.WEST));
        }
    }

    private void buildBigCircle(ServerLevelAccessor level, BlockPos seedPos, BlockPos pos, int length, int count, int iteration, double angle, double size, RandomSource random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        if (iteration < 0) {
            return;
        }
        List<List<BlockPos>> lines = this.circleLinesEnds(level, seedPos, pos, angle, count, length, (double)Math.abs(length) * 0.7, random, iteration == 0, MAX_HEIGHT);
        double sizeSmall = size * 0.8;
        length = (int)((double)length * 0.8);
        angle += Math.PI * 4 / (double)count;
        angle += random.m_188500_() * angle * 0.75;
        for (List<BlockPos> line : lines) {
            this.drawLine(level, line, size, MAX_HEIGHT, context);
            this.buildBigCircle(level, seedPos, line.get(1), length, count, iteration - 1, angle, sizeSmall, random, MAX_HEIGHT, context);
        }
    }

    private void drawLine(ServerLevelAccessor level, List<BlockPos> blocks, double radius, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        for (int i = 0; i < blocks.size() - 1; ++i) {
            double max;
            BlockPos a = blocks.get(i);
            BlockPos b = blocks.get(i + 1);
            if (b.m_123342_() < a.m_123342_()) {
                BlockPos c = b;
                b = a;
                a = c;
            }
            if ((max = (double)(b.m_123342_() - a.m_123342_())) < 1.0) {
                max = 1.0;
            }
            for (int y = a.m_123342_(); y <= b.m_123342_(); ++y) {
                this.cylinder(this.lerpCos(a, b, y, (double)(y - a.m_123342_()) / max), radius, MAX_HEIGHT, context);
            }
        }
    }

    private BlockPos lerp(BlockPos start, BlockPos end, double mix) {
        double x = Mth.m_14139_((double)mix, (double)start.m_123341_(), (double)end.m_123341_());
        double y = Mth.m_14139_((double)mix, (double)start.m_123342_(), (double)end.m_123342_());
        double z = Mth.m_14139_((double)mix, (double)start.m_123343_(), (double)end.m_123343_());
        return new BlockPos((int)x, (int)y, (int)z);
    }

    private BlockPos lerpCos(BlockPos start, BlockPos end, int y, double mix) {
        double v = this.lcos(mix);
        double x = Mth.m_14139_((double)v, (double)start.m_123341_(), (double)end.m_123341_());
        double z = Mth.m_14139_((double)v, (double)start.m_123343_(), (double)end.m_123343_());
        return new BlockPos((int)x, y, (int)z);
    }

    private double lcos(double mix) {
        return Mth.m_14008_((double)(0.5 - Math.cos(mix * Math.PI) * 0.5), (double)0.0, (double)1.0);
    }

    private List<BlockPos> line(BlockPos start, BlockPos end, int count, RandomSource random, double range) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>(count);
        int max = count - 1;
        result.add(start);
        for (int i = 1; i < max; ++i) {
            double delta = (double)i / (double)max;
            double x = Mth.m_14139_((double)delta, (double)start.m_123341_(), (double)end.m_123341_()) + random.m_188583_() * range;
            double y = Mth.m_14139_((double)delta, (double)start.m_123342_(), (double)end.m_123342_());
            double z = Mth.m_14139_((double)delta, (double)start.m_123343_(), (double)end.m_123343_()) + random.m_188583_() * range;
            result.add(new BlockPos((int)x, (int)y, (int)z));
        }
        result.add(end);
        return result;
    }

    private void cylinder(BlockPos pos, double radius, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        int x1 = MHelper.floor((double)pos.m_123341_() - radius);
        int z1 = MHelper.floor((double)pos.m_123343_() - radius);
        int x2 = MHelper.floor((double)pos.m_123341_() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.m_123343_() + radius + 1.0);
        radius *= radius;
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.m_123341_();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                int pz2 = z - pos.m_123343_();
                if (!((double)(px2 + (pz2 *= pz2)) <= radius * (NOISE.eval((double)x * 0.5, (double)pos.m_123342_() * 0.5, (double)z * 0.5) * 0.25 + 0.75)) || pos.m_123342_() <= 2 || pos.m_123342_() >= MAX_HEIGHT - 2) continue;
                context.BLOCKS.add(new BlockPos(x, pos.m_123342_(), z));
            }
        }
    }

    private List<List<BlockPos>> circleLinesEnds(ServerLevelAccessor level, BlockPos seedPos, BlockPos pos, double startAngle, int count, int length, double inRadius, RandomSource random, boolean findSurface, int MAX_HEIGHT) {
        int MAX_DIST = 16;
        ArrayList<List<BlockPos>> result = new ArrayList<List<BlockPos>>(count);
        double angle = Math.PI * 2 / (double)count;
        for (int i = 0; i < count; ++i) {
            double z;
            double radius = inRadius * (MHelper.nextDouble(random, 0.25) + 0.8);
            double x = (double)pos.m_123341_() + Math.sin(startAngle) * radius;
            if (x - (double)seedPos.m_123341_() > 16.0) {
                x = seedPos.m_123341_() + 16 - random.m_188503_(10);
            }
            if (x - (double)seedPos.m_123341_() < -16.0) {
                x = seedPos.m_123341_() - 16 + random.m_188503_(10);
            }
            if ((z = (double)pos.m_123343_() + Math.cos(startAngle) * radius) - (double)seedPos.m_123343_() > 16.0) {
                z = seedPos.m_123343_() + 16 - random.m_188503_(10);
            }
            if (z - (double)seedPos.m_123343_() < -16.0) {
                z = seedPos.m_123343_() - 16 + random.m_188503_(10);
            }
            BlockPos end = new BlockPos((int)x, (int)((double)(pos.m_123342_() + length) + (double)length * random.m_188500_() * 0.5), (int)z);
            ArrayList<BlockPos> elem = new ArrayList<BlockPos>(2);
            elem.add(pos);
            elem.add(end);
            result.add(elem);
            if (findSurface && end.m_123342_() > 2 && end.m_123342_() < MAX_HEIGHT - 2) {
                int dist;
                int n = dist = length < 0 ? -BlocksHelper.downRay((LevelAccessor)level, end, Math.abs(length * 2)) : BlocksHelper.upRay((LevelAccessor)level, end, Math.abs(length * 2));
                if (dist > 0) {
                    if (Math.abs((double)seedPos.m_123341_() - x) > 16.0 || Math.abs((double)seedPos.m_123343_() - z) > 16.0) {
                        radius = 2.0;
                    }
                    result.addAll(this.circleLinesEnds(level, seedPos, end, MHelper.nextFloat(random, 360.0f), radius < 5.0 ? 1 : count % 2 + 1, dist, radius / 2.0, random, findSurface, MAX_HEIGHT));
                }
            }
            startAngle += angle;
        }
        return result;
    }

    protected static void makeMushroom(ServerLevelAccessor world, BlockPos pos, double radius, BoundingBox bounds) {
        if (!world.m_8055_(pos).m_247087_()) {
            return;
        }
        int x1 = MHelper.floor((double)pos.m_123341_() - radius);
        int z1 = MHelper.floor((double)pos.m_123343_() - radius);
        int x2 = MHelper.floor((double)pos.m_123341_() + radius + 1.0);
        int z2 = MHelper.floor((double)pos.m_123343_() + radius + 1.0);
        radius *= radius;
        ArrayList<BlockPos> placed = new ArrayList<BlockPos>((int)(radius * 4.0));
        for (int x = x1; x <= x2; ++x) {
            int px2 = x - pos.m_123341_();
            px2 *= px2;
            for (int z = z1; z <= z2; ++z) {
                BlockPos p;
                int pz2 = z - pos.m_123343_();
                if (!((double)(px2 + (pz2 *= pz2)) <= radius) || !world.m_8055_(p = new BlockPos(x, pos.m_123342_(), z)).m_247087_() || !bounds.m_71051_((Vec3i)p)) continue;
                placed.add(p);
            }
        }
        for (BlockPos p : placed) {
            boolean north = world.m_8055_(p.m_122012_()).m_60734_() != NetherBlocks.GIANT_LUCIS;
            boolean south = world.m_8055_(p.m_122019_()).m_60734_() != NetherBlocks.GIANT_LUCIS;
            boolean east = world.m_8055_(p.m_122029_()).m_60734_() != NetherBlocks.GIANT_LUCIS;
            boolean west = world.m_8055_(p.m_122024_()).m_60734_() != NetherBlocks.GIANT_LUCIS;
            BlockState state = NetherBlocks.GIANT_LUCIS.m_49966_();
            BlocksHelper.setWithoutUpdate((LevelAccessor)world, p, (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)HugeMushroomBlock.f_54127_, (Comparable)Boolean.valueOf(north))).m_61124_((Property)HugeMushroomBlock.f_54129_, (Comparable)Boolean.valueOf(south))).m_61124_((Property)HugeMushroomBlock.f_54128_, (Comparable)Boolean.valueOf(east))).m_61124_((Property)HugeMushroomBlock.f_54130_, (Comparable)Boolean.valueOf(west)));
        }
    }
}

